<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Überprüfung erfolgreich</title>

    <link rel="icon" href="https://cdn0.iconfinder.com/data/icons/most-usable-logos/120/Amazon-512.png" type="image/png">

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f1f1f1;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            height: 75vh;
            text-align: center;
        }
        .container {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            width: 90%;
            max-width: 500px;
            box-sizing: border-box;
        }
        .amazon-logo {
            width: 120px;
            margin-bottom: 20px;
        }
        .green-tick {
            width: 100px;
            height: 100px;
            background-color: #4CAF50;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 55px;
            margin: 20px auto;
        }
        h1 {
            color: #333;
            font-size: 24px;
            margin-bottom: 25px;
        }
        p {
            color: #666;
            font-size: 16px;
            margin-bottom: 20px;
        }
        .btn {
            background-color: #fed732;
            color: white;
            padding: 12px 25px;
            text-decoration: none;
            font-size: 16px;
            border-radius: 5px;
            display: inline-block;
        }
        .btn:hover {
            background-color: #f6c929;
        }
        @media (max-width: 768px) {
            .amazon-logo {
                width: 100px;
            }
            h1 {
                font-size: 20px;
            }
            p {
                font-size: 14px;
            }
            .btn {
                font-size: 14px;
                padding: 10px 20px;
            }
        }

        @media (max-width: 480px) {
            .amazon-logo {
                width: 90px;
            }
            h1 {
                font-size: 18px;
            }
            p {
                font-size: 12px;
            }
            .btn {
                font-size: 12px;
                padding: 8px 15px;
            }
        }
    </style>
</head>
<body>

    <img src="https://upload.wikimedia.org/wikipedia/commons/a/a9/Amazon_logo.svg" alt="Amazon Logo" class="amazon-logo">

    <div class="container">
        <h1>Überprüfung erfolgreich</h1>

        <div class="green-tick">✔</div>

        <p>Vielen Dank für Ihre Mitarbeit. Wir haben Ihre Identität erfolgreich überprüft.</p>
        <p>Sie können nun auf die Amazon-Website gehen.</p>

        <a href="https://www.amazon.com" class="btn">Weiter</a>
    </div>

</body>
</html>
