<?php
session_start();

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $blacklisted_isp = $_POST['isp'];

    if (!empty($blacklisted_isp)) {
        file_put_contents('../list_isp.txt', $blacklisted_isp . PHP_EOL, FILE_APPEND);
        $message = "ISP '$blacklisted_isp' berhasil ditambahkan!";
    } else {
        $message = "Mohon masukkan ISP yang valid!";
    }
}

$blacklisted_ips = file_exists('../list_isp.txt') ? file('../list_isp.txt', FILE_IGNORE_NEW_LINES) : [];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Blacklist ISP - Pink Edition</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;600;900&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --pink-main: #ff69b4;
            --pink-glow: #ff1493;
            --bg-dark: #1a0a12;
            --card-bg: rgba(45, 19, 32, 0.85);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: radial-gradient(circle, #2d1320 0%, #000000 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #fff;
            padding: 20px;
        }

        .container {
            display: flex;
            justify-content: center;
            align-items: flex-start;
            flex-wrap: wrap;
            gap: 30px;
            max-width: 1100px;
            width: 100%;
        }

        .box {
            background-color: var(--card-bg);
            padding: 40px 35px;
            border-radius: 20px;
            border: 1px solid var(--pink-main);
            box-shadow: 0 0 20px rgba(255, 105, 180, 0.2);
            width: 48%;
            text-align: center;
            backdrop-filter: blur(10px);
            transition: 0.3s;
        }

        .box:hover {
            box-shadow: 0 0 30px rgba(255, 105, 180, 0.3);
        }

        .login-title, .blacklist-title {
            font-family: 'Orbitron', sans-serif;
            font-size: 24px;
            margin-bottom: 25px;
            color: var(--pink-main);
            font-weight: bold;
            text-transform: uppercase;
            text-shadow: 0 0 10px var(--pink-glow);
        }

        .input-container {
            margin-bottom: 20px;
        }

        input[type="text"] {
            font-family: 'Poppins', sans-serif;
            width: 100%;
            padding: 15px;
            font-size: 15px;
            border: 1px solid rgba(255, 105, 180, 0.4);
            border-radius: 10px;
            background-color: rgba(0, 0, 0, 0.3);
            color: #fff;
            outline: none;
            transition: 0.3s;
        }

        input[type="text"]:focus {
            border-color: var(--pink-main);
            box-shadow: 0 0 12px rgba(255, 105, 180, 0.4);
        }

        .login-button {
            font-family: 'Orbitron', sans-serif;
            background-color: var(--pink-main);
            color: #fff;
            padding: 15px;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: bold;
            width: 100%;
            cursor: pointer;
            transition: 0.3s;
            text-transform: uppercase;
        }

        .login-button:hover {
            background-color: var(--pink-glow);
            box-shadow: 0 0 20px var(--pink-main);
            transform: translateY(-2px);
        }

        .dashboard-button {
            display: block;
            font-family: 'Orbitron', sans-serif;
            background-color: transparent;
            color: var(--pink-main);
            padding: 12px;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid var(--pink-main);
            border-radius: 10px;
            cursor: pointer;
            text-decoration: none;
            margin-top: 15px;
            transition: 0.3s;
        }

        .dashboard-button:hover {
            background-color: rgba(255, 105, 180, 0.1);
        }

        textarea {
            font-family: 'Consolas', monospace;
            width: 100%;
            padding: 15px;
            font-size: 14px;
            border: 1px solid rgba(255, 105, 180, 0.3);
            border-radius: 10px;
            background-color: rgba(0, 0, 0, 0.4);
            color: #ffc0cb;
            outline: none;
            resize: none;
            height: 280px;
        }

        .error {
            background: rgba(255, 105, 180, 0.15);
            color: var(--pink-main);
            padding: 10px;
            border-radius: 8px;
            font-size: 14px;
            margin-bottom: 20px;
            border-left: 4px solid var(--pink-main);
        }

        @media (max-width: 900px) {
            .box { width: 100%; }
            body { overflow-y: auto; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="box left">
            <div class="login-title">Add ISP Blacklist</div>
            
            <?php if (isset($message)): ?>
                <div class="error"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="input-container">
                    <input type="text" name="isp" placeholder="Example: DigitalOcean, Ltd." required>
                </div>
                <button type="submit" class="login-button">Add to Blacklist</button>
                <a href="dashboard.php" class="dashboard-button">Return Dashboard</a>
            </form>
        </div>

        <div class="box right">
            <div class="blacklist-title">Blacklisted List</div>
            <textarea readonly><?php echo implode("\n", $blacklisted_ips); ?></textarea>
        </div>
    </div>
</body>
</html>